<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Job extends Model 
{

    protected $table = 'jobs';
    public $timestamps = true;
    protected $fillable = array('type', 'title_en', 'title_ar', 'details_en', 'details_ar', 'activation', 'is_featured');

    public function photo()
    {
        return $this->morphOne('App\Models\Photo');
    }

    public function tags()
    {
        return $this->morphMany('App\Models\Tag');
    }

}